<?php
require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/includes/functions.php';
require_once __DIR__ . '/api/esim-api.php';

$countryCode = $_GET['code'] ?? '';
if (empty($countryCode)) {
    header('Location: /');
    exit;
}

// Get country name from static list
$countries = require __DIR__ . '/data/countries.php';
$countryName = '';
$countryNameFa = '';
foreach ($countries as $country) {
    if (strtoupper($country['iso']) == strtoupper($countryCode)) {
        $countryName = $country['name'];
        $countryNameFa = $country['name_fa'];
        break;
    }
}

if (empty($countryName)) {
    header('Location: /');
    exit;
}

// Try to get packages from API
$api = new eSIMAPI();
$packagesData = $api->getCountryPackages(strtoupper($countryCode));
$packages = [];
$apiError = false;

if ($packagesData && isset($packagesData['obj']['packageList'])) {
    $packages = $packagesData['obj']['packageList'];
} else {
    $apiError = true;
    error_log("Failed to get packages for country: " . $countryCode);
}

$pageTitle = 'بسته‌های ' . $countryNameFa;
include __DIR__ . '/includes/header.php';
?>

<style>
@import url('https://fonts.googleapis.com/css2?family=Vazirmatn:wght@400;500;600;700;800&display=swap');

body, h1, h2, h3, h4, h5, h6, p, span, div, a, button, input, textarea, select, label {
    font-family: 'Vazirmatn', Tahoma, Arial, sans-serif !important;
}

.fas, .far, .fab, .fa {
    font-family: "Font Awesome 6 Free", "Font Awesome 6 Brands" !important;
}

.breadcrumb {
    padding: 15px 0;
    color: #666;
    font-size: 14px;
}

.breadcrumb a {
    color: #CB1919;
    text-decoration: none;
}

.breadcrumb i {
    margin: 0 8px;
    font-size: 12px;
}

.country-header {
    background: white;
    border-radius: 15px;
    padding: 40px;
    margin-bottom: 30px;
    box-shadow: 0 3px 15px rgba(0, 0, 0, 0.1);
    text-align: center;
}

.country-flag-large {
    width: 150px;
    height: 100px;
    object-fit: cover;
    border-radius: 10px;
    box-shadow: 0 3px 15px rgba(0, 0, 0, 0.2);
    margin-bottom: 20px;
}

.country-header h1 {
    color: #CB1919;
    font-size: 32px;
    font-weight: 700;
    margin-bottom: 10px;
}

.filters {
    background: white;
    border-radius: 12px;
    padding: 25px;
    margin-bottom: 30px;
    box-shadow: 0 3px 15px rgba(0, 0, 0, 0.1);
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 20px;
}

.filter-group {
    display: flex;
    flex-direction: column;
    gap: 8px;
}

.filter-group label {
    font-weight: 600;
    color: #333;
    font-size: 14px;
}

.filter-group select {
    padding: 12px;
    border: 2px solid #e0e0e0;
    border-radius: 8px;
    font-size: 14px;
    background: white;
    color: #333;
    cursor: pointer;
    transition: all 0.3s;
}

.filter-group select:hover {
    border-color: #CB1919;
}

.filter-group select:focus {
    outline: none;
    border-color: #CB1919;
    box-shadow: 0 0 0 3px rgba(203, 25, 25, 0.1);
}

.packages-grid {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(320px, 1fr));
    gap: 25px;
    margin-bottom: 50px;
}

.package-card {
    background: white;
    border-radius: 12px;
    padding: 25px;
    box-shadow: 0 3px 15px rgba(0, 0, 0, 0.1);
    transition: transform 0.3s, box-shadow 0.3s;
    position: relative;
}

.package-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 5px 25px rgba(0, 0, 0, 0.15);
}

.package-esim-image {
    width: 120px;
    height: 120px;
    margin: 0 auto 20px;
    display: flex;
    align-items: center;
    justify-content: center;
}

.package-esim-image svg {
    width: 100%;
    height: 100%;
    filter: drop-shadow(0 4px 8px rgba(0, 0, 0, 0.1));
}

.package-badge {
    position: absolute;
    top: 15px;
    left: 15px;
    background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
    color: white;
    padding: 5px 15px;
    border-radius: 20px;
    font-size: 12px;
    font-weight: bold;
}

.package-header h3 {
    color: #333;
    font-size: 18px;
    margin-bottom: 15px;
    padding-bottom: 15px;
    border-bottom: 2px solid #f0f0f0;
}

.package-details {
    margin: 15px 0;
}

.detail-item {
    display: flex;
    align-items: center;
    gap: 10px;
    padding: 10px 0;
    color: #666;
}

.detail-item i {
    color: #CB1919;
    width: 20px;
}

.package-description {
    background: #f8f9fa;
    padding: 15px;
    border-radius: 8px;
    margin: 15px 0;
    font-size: 14px;
    line-height: 1.6;
    color: #666;
}

.countries-link {
    color: #667eea;
    text-decoration: none;
    font-weight: 600;
}

.countries-link:hover {
    text-decoration: underline;
}

.package-price {
    text-align: center;
    margin: 20px 0;
}

.price-usd {
    color: #999;
    font-size: 14px;
    margin-bottom: 5px;
}

.price-usd del {
    color: #ccc;
}

.price-irr {
    font-size: 28px;
    font-weight: bold;
    color: #667eea;
}

.btn {
    display: block;
    width: 100%;
    padding: 14px;
    text-align: center;
    text-decoration: none;
    border-radius: 8px;
    font-weight: bold;
    transition: all 0.3s;
}

.btn-primary {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
}

.btn-primary:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(102, 126, 234, 0.4);
}

.btn-block {
    display: block;
    width: 100%;
}

.no-packages {
    text-align: center;
    padding: 60px 20px;
    background: white;
    border-radius: 15px;
    box-shadow: 0 3px 15px rgba(0, 0, 0, 0.1);
}

.no-packages i {
    font-size: 60px;
    color: #ddd;
    margin-bottom: 20px;
}

.no-packages h2 {
    color: #333;
    margin-bottom: 15px;
}

.no-packages p {
    color: #666;
    margin: 10px 0;
}

/* Modal Styles */
.countries-modal {
    display: none;
    position: fixed;
    z-index: 1000;
    left: 0;
    top: 0;
    width: 100%;
    height: 100%;
    background-color: rgba(0, 0, 0, 0.5);
}

.countries-modal-content {
    background-color: white;
    margin: 5% auto;
    padding: 0;
    border-radius: 15px;
    width: 90%;
    max-width: 600px;
    max-height: 80vh;
    overflow: hidden;
    box-shadow: 0 5px 30px rgba(0, 0, 0, 0.3);
}

.countries-modal-header {
    padding: 20px 25px;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.countries-modal-header h3 {
    margin: 0;
    font-size: 20px;
}

.countries-modal-close {
    background: none;
    border: none;
    color: white;
    font-size: 32px;
    cursor: pointer;
    line-height: 1;
}

.countries-modal-body {
    padding: 25px;
    max-height: 60vh;
    overflow-y: auto;
}

.countries-list {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(200px, 1fr));
    gap: 15px;
}

.country-item {
    display: flex;
    align-items: center;
    gap: 10px;
    padding: 10px;
    background: #f8f9fa;
    border-radius: 8px;
}

.country-item img {
    width: 40px;
    height: 27px;
    object-fit: cover;
    border-radius: 4px;
}

@media (max-width: 768px) {
    .packages-grid {
        grid-template-columns: 1fr;
    }
    
    .countries-list {
        grid-template-columns: 1fr;
    }
}
</style>

<div class="container">
    <div class="breadcrumb">
        <a href="/">خانه</a>
        <i class="fas fa-chevron-left"></i>
        <span><?php echo htmlspecialchars($countryNameFa); ?></span>
    </div>

    <div class="country-header">
        <img src="https://flagcdn.com/w320/<?php echo strtolower($countryCode); ?>.png" 
             alt="<?php echo htmlspecialchars($countryName); ?>"
             class="country-flag-large"
             onerror="this.src='https://via.placeholder.com/150x100?text=<?php echo $countryCode; ?>'">
        <h1>بسته‌های eSIM <?php echo htmlspecialchars($countryNameFa); ?></h1>
        <p style="color: #666;"><?php echo count($packages); ?> بسته موجود</p>
    </div>

    <div class="filters">
        <div class="filter-group">
            <label>فیلتر بر اساس حجم:</label>
            <select id="dataFilter">
                <option value="">همه</option>
                <option value="1">1 گیگابایت</option>
                <option value="3">3 گیگابایت</option>
                <option value="5">5 گیگابایت</option>
                <option value="10">10 گیگابایت</option>
                <option value="20">20+ گیگابایت</option>
            </select>
        </div>
        <div class="filter-group">
            <label>فیلتر بر اساس مدت:</label>
            <select id="daysFilter">
                <option value="">همه</option>
                <option value="1">۱ روز</option>
                <option value="7">۷ روز</option>
                <option value="15">۱۵ روز</option>
                <option value="30">۳۰ روز</option>
                <option value="60">۶۰+ روز</option>
            </select>
        </div>
        <div class="filter-group">
            <label>مرتب‌سازی:</label>
            <select id="sortBy">
                <option value="price-asc">قیمت: کم به زیاد</option>
                <option value="price-desc">قیمت: زیاد به کم</option>
                <option value="data-asc">حجم: کم به زیاد</option>
                <option value="data-desc">حجم: زیاد به کم</option>
            </select>
        </div>
    </div>

    <div class="packages-grid" id="packagesGrid">
        <?php foreach ($packages as $package): 
            // Convert API price from cents to dollars
            $priceUsd = $package['price'] / 10000;
            $priceIrr = usdToIrr($priceUsd);
            
            // Convert volume from bytes to GB
            $volumeGB = $package['volume'] / 1073741824; // 1024^3
            $volumeMB = round($volumeGB * 1024);
            
            // Format data display
            if ($volumeGB >= 1) {
                $dataDisplay = round($volumeGB, 1) . ' GB';
            } else {
                $dataDisplay = round($volumeMB) . ' MB';
            }
            
            $durationDays = $package['duration'];
            $packageName = $package['name'];
            $packageCode = $package['packageCode'];
            $speed = $package['speed'] ?? '4G/5G';
            $isFavorite = !empty($package['favorite']);
            
            // Build description
            $locationNames = [];
            if (isset($package['locationNetworkList']) && is_array($package['locationNetworkList'])) {
                foreach ($package['locationNetworkList'] as $loc) {
                    if (isset($loc['locationName'])) {
                        $locationNames[] = $loc['locationName'];
                    }
                }
            }
            
            $locationCount = count($locationNames);
            $modalId = 'countriesModal' . $packageCode;
            
            $description = "";
            if ($locationCount > 3) {
                $description = "این بسته برای استفاده در <a href='javascript:void(0)' class='countries-link' onclick='showCountriesModal(\"{$modalId}\")'>$locationCount کشور</a> مختلف قابل استفاده است. ";
            } elseif ($locationCount > 0) {
                $description = "قابل استفاده در: " . implode('، ', $locationNames) . ". ";
            }
            
            if (isset($package['activeType'])) {
                if ($package['activeType'] == 1) {
                    $description .= "فعال‌سازی بلافاصله پس از نصب. ";
                } elseif ($package['activeType'] == 2) {
                    $description .= "فعال‌سازی هنگام اولین اتصال به شبکه. ";
                }
            }
            
            if (empty($description)) {
                $description = "بسته اینترنت {$dataDisplay} با اعتبار {$durationDays} روزه و سرعت {$speed}.";
            }
        ?>
        <div class="package-card" 
             data-data="<?php echo $volumeMB; ?>" 
             data-days="<?php echo $durationDays; ?>"
             data-price="<?php echo $priceIrr; ?>">
            <?php if ($isFavorite): ?>
            <div class="package-badge">محبوب</div>
            <?php endif; ?>
            
            <!-- eSIM Image -->
            <div class="package-esim-image">
                <svg viewBox="0 0 200 200" xmlns="http://www.w3.org/2000/svg">
                    <!-- SIM Card Shape -->
                    <path d="M40 20 L160 20 L160 40 L180 60 L180 180 L20 180 L20 20 L40 20 Z" 
                          fill="#667eea" stroke="#5568d3" stroke-width="3"/>
                    
                    <!-- Chip Pattern -->
                    <rect x="60" y="70" width="80" height="80" rx="8" fill="#f0f0f0" stroke="#333" stroke-width="2"/>
                    
                    <!-- Chip Lines -->
                    <line x1="70" y1="85" x2="130" y2="85" stroke="#333" stroke-width="2"/>
                    <line x1="70" y1="100" x2="130" y2="100" stroke="#333" stroke-width="2"/>
                    <line x1="70" y1="115" x2="130" y2="115" stroke="#333" stroke-width="2"/>
                    <line x1="70" y1="130" x2="130" y2="130" stroke="#333" stroke-width="2"/>
                    
                    <line x1="85" y1="75" x2="85" y2="145" stroke="#333" stroke-width="2"/>
                    <line x1="100" y1="75" x2="100" y2="145" stroke="#333" stroke-width="2"/>
                    <line x1="115" y1="75" x2="115" y2="145" stroke="#333" stroke-width="2"/>
                    
                    <!-- eSIM Text -->
                    <text x="100" y="45" font-family="Arial, sans-serif" font-size="16" font-weight="bold" 
                          fill="white" text-anchor="middle">eSIM</text>
                </svg>
            </div>
            
            <div class="package-header">
                <h3><?php echo htmlspecialchars($packageName); ?></h3>
            </div>
            <div class="package-details">
                <div class="detail-item">
                    <i class="fas fa-database"></i>
                    <span><strong>حجم:</strong> <?php echo $dataDisplay; ?></span>
                </div>
                <div class="detail-item">
                    <i class="fas fa-calendar"></i>
                    <span><strong>مدت:</strong> <?php echo $durationDays; ?> روز</span>
                </div>
                <div class="detail-item">
                    <i class="fas fa-signal"></i>
                    <span><strong>شبکه:</strong> <?php echo htmlspecialchars($speed); ?></span>
                </div>
            </div>
            
            <div class="package-description">
                <?php echo $description; ?>
            </div>
            <div class="package-price">
                <div class="price-irr">
                    <?php echo formatPrice($priceIrr); ?> تومان
                </div>
            </div>
            <a href="/checkout.php?package=<?php echo $packageCode; ?>&country=<?php echo $countryCode; ?>" class="btn btn-primary btn-block">
                <i class="fas fa-shopping-cart"></i>
                خرید این eSIM
            </a>
        </div>
        
        <!-- Modal for countries list -->
        <?php if ($locationCount > 3): ?>
        <div id="<?php echo $modalId; ?>" class="countries-modal">
            <div class="countries-modal-content">
                <div class="countries-modal-header">
                    <h3>
                        <i class="fas fa-globe"></i>
                        کشورهای قابل استفاده
                    </h3>
                    <button class="countries-modal-close" onclick="closeCountriesModal('<?php echo $modalId; ?>')">&times;</button>
                </div>
                <div class="countries-modal-body">
                    <div class="countries-list">
                        <?php 
                        foreach ($locationNames as $locationName): 
                            $locationCode = '';
                            foreach ($package['locationNetworkList'] as $loc) {
                                if ($loc['locationName'] == $locationName && isset($loc['locationCode'])) {
                                    $locationCode = strtolower($loc['locationCode']);
                                    break;
                                }
                            }
                        ?>
                        <div class="country-item">
                            <?php if ($locationCode): ?>
                            <img src="https://flagcdn.com/w40/<?php echo $locationCode; ?>.png" 
                                 alt="<?php echo htmlspecialchars($locationName); ?>"
                                 onerror="this.style.display='none'">
                            <?php endif; ?>
                            <span><?php echo htmlspecialchars($locationName); ?></span>
                        </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
        </div>
        <?php endif; ?>
        
        <?php endforeach; ?>
    </div>

    <?php if ($apiError): ?>
    <div class="no-packages">
        <i class="fas fa-exclamation-triangle"></i>
        <h2>خطا در دریافت اطلاعات</h2>
        <p>متأسفانه در حال حاضر امکان دریافت بسته‌ها از سرور وجود ندارد.</p>
        <p>لطفاً چند دقیقه دیگر دوباره تلاش کنید.</p>
        <a href="/" class="btn btn-primary">بازگشت به صفحه اصلی</a>
    </div>
    <?php elseif (empty($packages)): ?>
    <div class="no-packages">
        <i class="fas fa-box-open"></i>
        <h2>بسته‌ای یافت نشد</h2>
        <p>متأسفانه در حال حاضر بسته‌ای برای این کشور موجود نیست.</p>
        <a href="/" class="btn btn-primary">بازگشت به صفحه اصلی</a>
    </div>
    <?php endif; ?>
</div>

<script>
function showCountriesModal(modalId) {
    document.getElementById(modalId).style.display = 'block';
}

function closeCountriesModal(modalId) {
    document.getElementById(modalId).style.display = 'none';
}

// Close modal when clicking outside
window.onclick = function(event) {
    if (event.target.classList.contains('countries-modal')) {
        event.target.style.display = 'none';
    }
}

// Package Filters
document.addEventListener('DOMContentLoaded', function() {
    const dataFilter = document.getElementById('dataFilter');
    const daysFilter = document.getElementById('daysFilter');
    const sortBy = document.getElementById('sortBy');
    
    const filterPackages = () => {
        const packageCards = document.querySelectorAll('.package-card');
        let visibleCards = Array.from(packageCards);
        
        // Apply data filter
        if (dataFilter && dataFilter.value) {
            const filterValue = parseInt(dataFilter.value);
            visibleCards = visibleCards.filter(card => {
                const dataMB = parseInt(card.getAttribute('data-data'));
                const dataGB = dataMB / 1024;
                
                if (filterValue === 20) {
                    return dataGB >= 20;
                } else {
                    return dataGB >= filterValue && dataGB < (filterValue + 2);
                }
            });
        }
        
        // Apply days filter
        if (daysFilter && daysFilter.value) {
            const filterValue = parseInt(daysFilter.value);
            visibleCards = visibleCards.filter(card => {
                const days = parseInt(card.getAttribute('data-days'));
                
                if (filterValue === 60) {
                    return days >= 60;
                } else if (filterValue === 30) {
                    return days >= 30 && days < 60;
                } else if (filterValue === 15) {
                    return days >= 15 && days < 30;
                } else if (filterValue === 7) {
                    return days >= 7 && days < 15;
                } else {
                    return days === filterValue;
                }
            });
        }
        
        // Hide all cards first
        packageCards.forEach(card => card.style.display = 'none');
        
        // Sort cards
        if (sortBy && sortBy.value) {
            const sortValue = sortBy.value;
            
            visibleCards.sort((a, b) => {
                if (sortValue === 'price-asc') {
                    return parseFloat(a.getAttribute('data-price')) - parseFloat(b.getAttribute('data-price'));
                } else if (sortValue === 'price-desc') {
                    return parseFloat(b.getAttribute('data-price')) - parseFloat(a.getAttribute('data-price'));
                } else if (sortValue === 'data-asc') {
                    return parseFloat(a.getAttribute('data-data')) - parseFloat(b.getAttribute('data-data'));
                } else if (sortValue === 'data-desc') {
                    return parseFloat(b.getAttribute('data-data')) - parseFloat(a.getAttribute('data-data'));
                }
                return 0;
            });
        }
        
        // Show filtered and sorted cards
        const grid = document.getElementById('packagesGrid');
        if (grid) {
            visibleCards.forEach(card => {
                card.style.display = 'block';
                grid.appendChild(card);
            });
        }
        
        // Show message if no packages found
        const noResults = document.getElementById('noResults');
        if (visibleCards.length === 0) {
            if (!noResults) {
                const msg = document.createElement('div');
                msg.id = 'noResults';
                msg.className = 'no-packages';
                msg.innerHTML = '<i class="fas fa-search"></i><p>هیچ بسته‌ای با این فیلترها یافت نشد.</p>';
                grid.parentNode.insertBefore(msg, grid.nextSibling);
            }
        } else {
            if (noResults) {
                noResults.remove();
            }
        }
    };
    
    if (dataFilter) dataFilter.addEventListener('change', filterPackages);
    if (daysFilter) daysFilter.addEventListener('change', filterPackages);
    if (sortBy) sortBy.addEventListener('change', filterPackages);
});
</script>

<?php include __DIR__ . '/includes/footer.php'; ?>
